<?php
include 'conexao.php';
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Ver Horário</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4">
    <h2 class="mb-4">Consultar Horário</h2>
    <form method="GET" class="row g-3">
      <div class="col-md-5">
        <label for="turma" class="form-label">Selecione a Turma</label>
        <select name="turma_id" id="turma" class="form-select">
          <option value="">-- Turma --</option>
          <?php
          $turmas = $conn->query("SELECT id, classe, curso, turno FROM turmas");
          while ($t = $turmas->fetch_assoc()):
          ?>
            <option value="<?= $t['id'] ?>" <?= isset($_GET['turma_id']) && $_GET['turma_id'] == $t['id'] ? 'selected' : '' ?>>
              <?= $t['classe'] . ' ' . $t['curso'] . ' (' . $t['turno'] . ')' ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-5">
        <label for="prof" class="form-label">Ou selecione o Professor</label>
        <select name="professor_id" id="prof" class="form-select">
          <option value="">-- Professor --</option>
          <?php
          $profs = $conn->query("SELECT id, nome FROM professores");
          while ($p = $profs->fetch_assoc()):
          ?>
            <option value="<?= $p['id'] ?>" <?= isset($_GET['professor_id']) && $_GET['professor_id'] == $p['id'] ? 'selected' : '' ?>>
              <?= $p['nome'] ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-2 d-grid">
        <label class="form-label">&nbsp;</label>
        <button class="btn btn-primary">Ver</button>
      </div>
    </form>

    <hr class="my-4">

    <?php
    $dias = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
    $tempos = [1, 2, 3, 4, 5, 6];

    $filtro = "";
    if (!empty($_GET['turma_id'])) {
      $filtro = "WHERE h.turma_id = " . intval($_GET['turma_id']);
    } elseif (!empty($_GET['professor_id'])) {
      $filtro = "WHERE h.professor = " . intval($_GET['professor_id']);
    }

    if ($filtro) {
      echo '<div class="table-responsive"><table class="table table-bordered align-middle text-center">';
      echo '<thead class="table-dark"><tr><th>Dia / Tempo</th>';
      foreach ($tempos as $tempo) echo "<th>{$tempo}º</th>";
      echo '</tr></thead><tbody>';

      foreach ($dias as $dia) {
        echo "<tr><th class='table-secondary'>$dia</th>";
        foreach ($tempos as $tempo) {
          $res = $conn->query("SELECT d.nome AS disciplina, p.nome AS professor FROM horario h JOIN disciplinas d ON h.disciplina = d.id JOIN professores p ON h.professor = p.id $filtro AND h.dia = '$dia' AND h.tempo = $tempo");
          if ($row = $res->fetch_assoc()) {
            echo "<td><strong>{$row['disciplina']}</strong><br><small>{$row['professor']}</small></td>";
          } else {
            echo "<td>-</td>";
          }
        }
        echo '</tr>';
      }
      echo '</tbody></table></div>';
    }
    ?>
  </div>
</body>
</html>
